#include <windows.h>
#include <stdio.h>
#include "resource.h"

#define WinClassName "systray_class"

HWND hWnd;
HMENU hMenu;
NOTIFYICONDATA NID;
BOOL Minimized = false;

LRESULT CALLBACK WindProc(HWND hWnd, UINT MSG, WPARAM wParam, LPARAM lParam)
{
 PAINTSTRUCT PS;
 switch(MSG)
 {
  case WM_PAINT://Lets get the dc when we have to redraw our window
  {
   BeginPaint(hWnd, &PS);
   HDC dc = PS.hdc;
   char str[256] = "Here you can do your usual stuff...";
   TextOut(dc, 0, 0, str, strlen(str));
   EndPaint(hWnd, &PS);
  }break;
  case WM_COMMAND:
  {
   switch(wParam)
   {
    case ID_MENU_TEST: MessageBox(hWnd, "testing", "SysTrayIcon[QSoft]", MB_OK); break;
    case ID_MENU_EXIT: PostQuitMessage(0); break;
   }
  }break;
  case WM_SIZE:
  {
   if (wParam == SIZE_MINIMIZED)
   {
    Minimized = true;
    ShowWindow(hWnd, SW_HIDE); // Hide our window just after the minimize is done.
    Shell_NotifyIcon(NIM_ADD, &NID); //Add the systray icon.
   }
  }break;
  case WM_SYSCOMMAND:
  {
   switch(LOWORD(wParam)) //We capture the 'X' button :)
   {
    case SC_CLOSE:
    {
     Minimized = false;
     ShowWindow(hWnd, SW_HIDE);
     Shell_NotifyIcon(NIM_ADD, &NID);
    }return(0);
   }
  }break;
  case WM_DESTROY:
  {
   PostQuitMessage(0);
  }break;
 }
 if (MSG == NID.uCallbackMessage) //This is where we get our SysTray Icon notifications.
 {
  switch(lParam)
  {
   case WM_RBUTTONUP: //Did the user right click?
   {//Pop up the menu.
    POINT mp;
    GetCursorPos(&mp);
    TrackPopupMenu(GetSubMenu(hMenu, 0), 0, mp.x, mp.y, 0, hWnd, 0);
   }break;
   case WM_LBUTTONUP: //Did the user left click?
   {//Show the window and remove the systray icon.
    ShowWindow(hWnd, SW_SHOW);
    if (Minimized) ShowWindow(hWnd, SW_RESTORE);
    Shell_NotifyIcon(NIM_DELETE, &NID);
   }break;
  }
 }
 return(DefWindowProc(hWnd, MSG, wParam, lParam));
}

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nShowCmd)
{
 MSG msg;
 WNDCLASS wc;
 wc.style = CS_HREDRAW | CS_VREDRAW;
 wc.lpfnWndProc = WindProc;
 wc.cbClsExtra = 0;
 wc.cbWndExtra = 0;
 wc.hbrBackground = (HBRUSH)GetStockObject(GRAY_BRUSH);
 wc.hIcon = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_ICON1));
 wc.hCursor = LoadCursor(NULL, IDC_ARROW); 
 wc.lpszClassName = WinClassName;
 wc.lpszMenuName = NULL;
 wc.hInstance = hInstance;
 if (!RegisterClass(&wc)) return(0);
 if (!(hWnd = CreateWindow(WinClassName, "SysTrayIcon", WS_OVERLAPPEDWINDOW, 0, 0, GetSystemMetrics(SM_CXFULLSCREEN), GetSystemMetrics(SM_CYFULLSCREEN), NULL, NULL, hInstance, NULL))) return(0);

 NID.cbSize = sizeof(NID); // Size of the structure duh :)
 NID.hIcon = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_ICON1)); // The icon that will be shown in the systray.
 NID.uCallbackMessage = WM_USER + 1; // Our user defined message.(For notifications, Windows will send us messages when user pressed on our icon)
 NID.hWnd = hWnd; // Handle to the window we would like to get the notifications.
 NID.uID = WM_USER + 2; // Icon ID in systray...
 strcpy(NID.szTip, "System Tray Icon[QSoft]"); // The tooltip string
 NID.uFlags = NIF_TIP | NIF_ICON | NIF_MESSAGE; // Here we say we want to get notifications about the icon, we have an icon and a tooltip.

 ShowWindow(hWnd, SW_SHOW);
 UpdateWindow(hWnd);

 hMenu = LoadMenu(hInstance, "menu1");

 while (1)
	{
  if (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
  {
   if (msg.message == WM_QUIT) break;
   TranslateMessage(&msg); 
   DispatchMessage(&msg); 
  }
  else
  {
  }
 }
 Shell_NotifyIcon(NIM_DELETE, &NID);
 return(msg.wParam);
}